//Thu Apr 20 09:02:07 PDT 2017
if (typeof(Stationery) == "undefined") {
    Stationery = {};
}

Stationery.constants = {
    mainComposeAreaID: (typeof(COMPOSE_CONTENT_ELEMENT_ID) !== 'undefined') ? COMPOSE_CONTENT_ELEMENT_ID : 'yahoo__compose_area',
    paperlessPostThemeProviderName: 'Paperless Post',
    motifTemplateName: 'motif_template',
    rteStationeryCoreClassName: 'rte-stationery-core',
    mobstoreBaseImageSrc: 'https://s.yimg.com/nq/tictac/stationery/themes/',
    clearStationeryClassName: 'btn-clear-stationery',
    stationeryEditableBodyID: 'middleBody',
    yahooQuotedBeginQuerySelector: '[class*=yahoo-quoted-begin]',
    outlineEnhancrQuerySelector: '[class*=enhancr-link-previews]',
    tableWrapperSelector: 'table[class*=wrapper]',
    noneStationeryThemeId: 'clearStationeryID',
    coreQuotedContentQuerySelector: 'blockquote',
    unoTemplateName: 'uno_template'
};

Stationery.getLocalizedString = function(strings) {
    var lang = (Stationery.deviceMetrics && Stationery.deviceMetrics.lang) || "en",
        interimLang = lang.substring(0, lang.lastIndexOf("-")),
        shortLang = lang.split("-")[0];
    return strings[lang] || strings[interimLang] || strings[shortLang] || strings["en"];
};

Stationery.getCoreBodyWithTheme = function(themeId) {
    var themeObj = JSON.parse(JSON.stringify(this.stationeryThemeConfig.stationeryThemes[themeId])),
        themeVersion = JSON.parse(JSON.stringify(this.stationeryThemeConfig.themeVersions[themeId])),
        templateName = themeObj.templateName,
        mobstoreBaseUrl = this.stationeryThemeConfig.stationeryMobThmPath,
        blockQuoteNode, yahooQuotedNode, coreContent, stationeryBodyNode, outlineEnhancrNode,
        rteCloneNode = document.createElement('div');

    rteCloneNode.innerHTML = document.querySelector('[id*=' + Stationery.constants.mainComposeAreaID + ']').innerHTML;
    blockQuoteNode = rteCloneNode.querySelector(Stationery.constants.coreQuotedContentQuerySelector);
    outlineEnhancrNode = rteCloneNode.querySelector(Stationery.constants.outlineEnhancrQuerySelector);

    if (blockQuoteNode) {
        blockQuoteNode.remove();
    }

    yahooQuotedNode = rteCloneNode.querySelector(Stationery.constants.yahooQuotedBeginQuerySelector);
    if (yahooQuotedNode) {
        yahooQuotedNode.remove();
    }

    if (outlineEnhancrNode) {
        outlineEnhancrNode.remove();
    }

    stationeryBodyNode = rteCloneNode.querySelector('[id*=' + Stationery.constants.stationeryEditableBodyID + ']');
    if (stationeryBodyNode) {
        coreContent = stationeryBodyNode.innerHTML;
    } else {
        coreContent = rteCloneNode.innerHTML;
    }

    themeObj.yahooStationery = true;
    themeObj.pplogo = themeObj.themeProviderName === "Paperless Post";
    if (typeof(LocalizedString) === 'object') {
        themeObj.msg_footer = LocalizedString.stationery_yahoo_attribution_footer;
    } else {
        themeObj.msg_footer = Stationery.strings ? Stationery.getLocalizedString(Stationery.strings.str_yahoo_mail_stationery) : "Yahoo Mail Stationery";
    }
    if (themeObj.topImg_src) {
        themeObj.topImg_src = mobstoreBaseUrl + themeVersion + '/' + themeObj.uniqueThemeName + '/' + themeObj.topImg_src;
    }
    if (themeObj.bottomImg_src) {
        themeObj.bottomImg_src = mobstoreBaseUrl + themeVersion + '/' + themeObj.uniqueThemeName + '/' + themeObj.bottomImg_src;
    }
    themeObj.messageText = coreContent;
    return Mustache.render(this.templates[templateName], themeObj);

};

Stationery.getReplyForwardBody = function() {
    var rteComposeNode = document.querySelector('[id*=' + Stationery.constants.mainComposeAreaID + ']'),
        coreContent = '',
        yahooQuotedNode = rteComposeNode.querySelector(Stationery.constants.yahooQuotedBeginQuerySelector),
        replyForwardQuotedNode = rteComposeNode.querySelector(Stationery.constants.coreQuotedContentQuerySelector),
        outlineEnhancrNode = rteComposeNode.querySelector(Stationery.constants.outlineEnhancrQuerySelector);

    if (yahooQuotedNode) {
        coreContent += yahooQuotedNode.outerHTML;
    }

    if (replyForwardQuotedNode) {
        coreContent += replyForwardQuotedNode.outerHTML;
    }

    if (outlineEnhancrNode) {
        coreContent += outlineEnhancrNode.outerHTML;
    }

    return coreContent;
};

Stationery.applyStationery = function(themeId) {
    // construct the new Compose Body
    var _this = this,
        replyForwardBody = _this.getReplyForwardBody(),
        coreBody = _this.getCoreBodyWithTheme(themeId),
        clearStationeryButton,
        rteStationeryNode, rteComposeNode = document.querySelector('[id*=' + Stationery.constants.mainComposeAreaID + ']');

    rteComposeNode.innerHTML = coreBody + replyForwardBody;

    // Attach the handlers and contentEditableFalse
    clearStationeryButton = document.querySelector('[class*=' + Stationery.constants.clearStationeryClassName + ']');
    clearStationeryButton.addEventListener('click', function() {
        _this.clearStationery();
    });

    rteComposeNode.contentEditable = 'false';
    rteStationeryNode = document.querySelector('[class*=' + Stationery.constants.rteStationeryCoreClassName + ']');
    rteStationeryNode.addEventListener('click', function(evt) {
        if (evt.target.hasAttribute('data-action')) {
            return;
        }
        var stationeryBodyNode = document.querySelector('[id*=' + Stationery.constants.stationeryEditableBodyID + ']');
        if (stationeryBodyNode) {
            stationeryBodyNode.focus();
        }
    }, false);

    _this.applyBehavior(themeId);

    //ios only
    if (window.bodyUpdated) {
        bodyUpdated();
    }

    // android only
    if (window.yMailBridge) {
        yMailBridge.setStationeryId(themeId);
    }
};

Stationery.initialize = function() {
    var rteStationeryNode, mainRTENode, stationeryBodyNode, clearStationeryButton, tableWrapperNode;
    mainRTENode = document.querySelector('[id*=' + Stationery.constants.mainComposeAreaID + ']');
    if (mainRTENode) {
        Stationery.appendStationeryStyles();
    }
    if (this.containsStationery()) {
        if (mainRTENode) {
            rteStationeryNode = document.querySelector('[class*=' + Stationery.constants.rteStationeryCoreClassName + ']');
            stationeryBodyNode = document.querySelector('[id*=' +  Stationery.constants.stationeryEditableBodyID + ']');
            rteStationeryNode.contentEditable = "false";
            mainRTENode.contentEditable = "false";
            stationeryBodyNode.contentEditable = "true";

            clearStationeryButton = rteStationeryNode.querySelector('.' + Stationery.constants.clearStationeryClassName);
            if (!clearStationeryButton) {
                clearStationeryButton = document.createElement('span');
                clearStationeryButton.className = Stationery.constants.clearStationeryClassName;
                tableWrapperNode = rteStationeryNode.querySelector(Stationery.constants.tableWrapperSelector);
                tableWrapperNode && tableWrapperNode.parentNode.insertBefore(clearStationeryButton, tableWrapperNode);
            }

            clearStationeryButton.addEventListener('click', function() {
                Stationery.clearStationery();
            });

            rteStationeryNode.addEventListener('click', function() {
                stationeryBodyNode.focus();
            });
        }
        var currentAppliedTheme = Stationery.currentAppliedTheme();
        Stationery.applyBehavior(currentAppliedTheme);
    }
};

Stationery.adjustToShowStationeryMode = function() {
    document.body.scrollTop = 0;
};

Stationery.appendStationeryStyles = function() {
    var str_clearStationery = Stationery.strings ? Stationery.getLocalizedString(Stationery.strings.str_clear_stationery) : "Clear Stationery";

    if (typeof(LocalizedString) === 'object') {
        str_clearStationery = LocalizedString.stationery_clear_stationery;
    }

    styleNode = document.createElement('style');
    styleNode.innerHTML = '.rte-stationery-core .btn-clear-stationery:after { content: "' + str_clearStationery + '"; }  blockquote .rte-stationery-core .btn-clear-stationery {display: none;} ';
    document.head.appendChild(styleNode);
};

Stationery.clearStationery = function() {
    var rteStationeryNode, mainRTENode, stationeryBodyNode, clearStationeryButton, coreHtmlContent;

    if (this.containsStationery()) {
        mainRTENode =  document.querySelector('[id*=' + Stationery.constants.mainComposeAreaID + ']');
        rteStationeryNode = document.querySelector('[class*=' + Stationery.constants.rteStationeryCoreClassName + ']');
        stationeryBodyNode = document.querySelector('[id*=' +  Stationery.constants.stationeryEditableBodyID + ']');

        rteStationeryNode.remove();
        coreHtmlContent = stationeryBodyNode.innerHTML;
        mainRTENode.innerHTML = coreHtmlContent + mainRTENode.innerHTML;
        mainRTENode.contentEditable = "true";

        this.clearBehavior();

        // ios only
        if (window.bodyUpdated) {
            bodyUpdated();
            setTimeout(function() {
                window.location = "ios://clear-stationery";
            }, 0);
        }

        // android only
        if (window.yMailBridge) {
            yMailBridge.setStationeryId(NONE_STATIONERY_ID);
            syncComposeContent(mainRTENode, false);
        }
    }
};

Stationery.currentAppliedTheme = function() {
    var imageNode, srcComponents;

    if (Stationery.containsStationery()) {
        imageNode = document.querySelector("img[src^='" + Stationery.constants.mobstoreBaseImageSrc + "']");
        srcComponents = imageNode.src.split("/");
        return srcComponents[srcComponents.length - 2];
    }
    return Stationery.constants.noneStationeryThemeId;
};

Stationery.containsStationery = function() {
    var mainRTENode = document.querySelector('[id*=' + Stationery.constants.mainComposeAreaID + ']') || document.body,
        totalStationeryCards, stationeryCardsInBlock, quotedNode;

    totalStationeryCards = mainRTENode.querySelectorAll("[class*='" + Stationery.constants.rteStationeryCoreClassName + "']").length;

    if (totalStationeryCards === 0) {
        return false;
    }

    quotedNode = mainRTENode.querySelector(Stationery.constants.coreQuotedContentQuerySelector);
    if (quotedNode) {
        stationeryCardsInBlock = quotedNode.querySelectorAll("[class*='" + Stationery.constants.rteStationeryCoreClassName + "']").length;
    } else {
        stationeryCardsInBlock = 0;
    }

    return (totalStationeryCards > stationeryCardsInBlock);
};

if (typeof(document) !== 'undefined') {
    document.addEventListener( "DOMContentLoaded", function() {
        Stationery.initialize();
    }, false );
}

Stationery.pickerOrder = function (isCorp, lang) {
    var returnArr = [], themeName, themeObj,
        i, themesInOrder = Stationery.templates.supportedThemesInOrder;

    for (i in themesInOrder) {
        themeName = themesInOrder[i];
        themeObj = Stationery.stationeryThemeConfig.stationeryThemes[themeName];

        if (!themeObj || (!isCorp && themeObj.restricted) || !themeObj.supportedLang_regex.test(lang)) {
            continue;
        } else {
            returnArr.push(themeName);
        }
    }

    return returnArr;
};

Stationery.clearBehavior = function() {
    var behaviorCssNode, behaviorJSNode;

    Stationery.behavior && Stationery.behavior.deinit && Stationery.behavior.deinit();
    delete Stationery.behavior;

    behaviorCssNode = document.head.querySelector("#behavior_css");
    behaviorJSNode = document.head.querySelector("#behavior_js");

    behaviorCssNode && behaviorCssNode.remove();
    behaviorJSNode && behaviorJSNode.remove();
};

Stationery.applyBehavior = function(themeId) {
    this.clearBehavior();

    var themeObj = JSON.parse(JSON.stringify(this.stationeryThemeConfig.stationeryThemes[themeId])),
        stationeryBehaviorPath = this.stationeryThemeConfig.stationeryBehaviorPath, linkNode, scriptNode;

    if (themeObj.extra_css) {
        // apply css
        linkNode = document.createElement("link");
        linkNode.rel = "stylesheet";
        linkNode.id = "behavior_css";
        linkNode.href = stationeryBehaviorPath + themeObj.extra_css;
        linkNode.type = "text/css";
        document.head.appendChild(linkNode);
    }

    if (themeObj.extra_js) {
        // apply js
        scriptNode = document.createElement("script");
        scriptNode.id = "behavior_js";
        scriptNode.src = stationeryBehaviorPath + themeObj.extra_js;
        document.head.appendChild(scriptNode);
    }
};

Stationery.supportedBehavior = {
    shake: function() {
        Stationery.behavior && Stationery.behavior.shake && Stationery.behavior.shake();
    }
};
